;;; - ------------------------------------------------------------------------------ - ;
;;; -                 T O O L - K_TEXT-VT                                            - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Beschreibung :  Texte lesbar drehen                                            - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Befehle      :  K_text-vt                                                      - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - letzte nderung am : 05.01.2023                                                - ;
;;; -              durch : Andreas Kraus                                             - ;
;;; - ------------------------------------------------------------------------------ - ;

(vl-load-com)
(DEFUN DEG (Z) (* (/ Z PI) 180.0))
(DEFUN K_->OBJ_NAME (NAME)
  (COND	((= (TYPE NAME) (QUOTE ENAME))
	 (vlax-ename->vla-object NAME)
	)
	((= (TYPE NAME) (QUOTE VLA-OBJECT)) NAME)
	((= (TYPE NAME) (QUOTE STR))
	 (vlax-ename->vla-object (HANDENT NAME))
	)
	((= (TYPE NAME) (QUOTE LIST))
	 (vlax-ename->vla-object (CDR (ASSOC -1 NAME)))
	)
  )
)
(DEFUN K_AC-DOC	nil
  (vla-get-ActiveDocument (vlax-get-acad-object))
)
(DEFUN K_GET_MERKLISTE (NAME / WERT)
  (IF (ASSOC NAME K_MERKLISTE)
    (SETQ WERT (NTH 1 (ASSOC NAME K_MERKLISTE)))
  )
  WERT
)
(DEFUN K_IS (WERT)
  (COND	((= WERT :vlax-false) nil)
	((= WERT :vlax-true) T)
	((= WERT nil) nil)
	((= WERT T) T)
	((= WERT 1) T)
	((= WERT 0) nil)
	((= WERT "1") T)
	((= WERT "0") nil)
	((= WERT "ja") T)
	((= WERT "nein") nil)
  )
)
(DEFUN K_NOT (WERT)
  (COND	((= WERT :vlax-false) :vlax-true)
	((= WERT :vlax-true) :vlax-false)
	((= WERT nil) T)
	((= WERT T) nil)
	((= WERT 1) 0)
	((= WERT 0) 1)
	((= WERT "1") "0")
	((= WERT "0") "1")
	((= WERT "ja") "nein")
	((= WERT "nein") "ja")
  )
)
(DEFUN K_PUT_MERKLISTE (NAME WERT)
  (IF (ASSOC NAME K_MERKLISTE)
    (SETQ K_MERKLISTE
	   (SUBST (LIST NAME WERT)
		  (ASSOC NAME K_MERKLISTE)
		  K_MERKLISTE
	   )
    )
    (SETQ K_MERKLISTE (CONS (LIST NAME WERT) K_MERKLISTE))
  )
  (PRINC)
)
(DEFUN K_RESTORE_VAR (VARLIST / K_SAVEVAR_LIST)
  (SETQ K_SAVEVAR_LIST (K_GET_MERKLISTE "k_savevar_list"))
  (IF (= VARLIST "*")
    (SETQ VARLIST (MAPCAR (QUOTE (LAMBDA (VAR) (NTH 0 VAR))) K_SAVEVAR_LIST))
  )
  (IF (= (TYPE VARLIST) (QUOTE STR))
    (SETQ VARLIST (LIST VARLIST))
  )
  (FOREACH VAR VARLIST
    (IF	(SETQ VAR (ASSOC VAR K_SAVEVAR_LIST))
      (SETVAR (NTH 0 VAR) (NTH 1 VAR))
    )
  )
)
(DEFUN K_SATZ->ENTLIST (SATZ)
  (IF (= (TYPE SATZ) (QUOTE PICKSET))
    (VL-REMOVE-IF-NOT
      (QUOTE (LAMBDA (DUMMY) (= (TYPE DUMMY) (QUOTE ENAME))))
      (MAPCAR (QUOTE CADR) (SSNAMEX SATZ))
    )
  )
)
(DEFUN K_SAVE_VAR (VARLIST / K_SAVEVAR_LIST)
  (SETQ K_SAVEVAR_LIST (K_GET_MERKLISTE "k_savevar_list"))
  (IF (= (TYPE VARLIST) (QUOTE STR))
    (SETQ VARLIST (LIST VARLIST))
  )
  (FOREACH VAR VARLIST
    (IF	(ASSOC VAR K_SAVEVAR_LIST)
      (SETQ K_SAVEVAR_LIST
	     (SUBST (LIST VAR (GETVAR VAR))
		    (ASSOC VAR K_SAVEVAR_LIST)
		    K_SAVEVAR_LIST
	     )
      )
      (SETQ K_SAVEVAR_LIST (CONS (LIST VAR (GETVAR VAR)) K_SAVEVAR_LIST))
    )
  )
  (K_PUT_MERKLISTE "k_savevar_list" K_SAVEVAR_LIST)
)
(DEFUN K_SSGET (TEXT FILTER / SATZ)
  (IF TEXT
    (PROGN (K_SAVE_VAR "NOMUTT")
	   (PRINC (STRCAT " " TEXT))
	   (SETVAR "NOMUTT" 1)
    )
  )
  (VL-CATCH-ALL-APPLY
    (LIST (QUOTE LAMBDA)
	  (QUOTE nil)
	  (QUOTE (SETQ SATZ (APPLY (QUOTE SSGET) FILTER)))
    )
  )
  (IF TEXT
    (K_RESTORE_VAR "NOMUTT")
  )
  SATZ
)
(DEFUN K_VARIANT->VALUE	(VAR / VALUE)
  (SETQ VALUE (vlax-variant-value VAR))
  (COND	((= (TYPE VALUE) (QUOTE safearray))
	 (IF (MINUSP (vlax-safearray-get-u-bound VALUE 1))
	   nil
	   (vlax-safearray->list VALUE)
	 )
	)
  )
)
(DEFUN LESERICHTUNG_DIALOG (/ AKTION B1	H H1 LESERICHTUNG LESERICHTUNG_ID MITTE	OK P PX	PY W WX	X1 X2 Y1 Y2)
  (DEFUN LESERICHTUNG_END (WERT)
    (SETQ LESERICHTUNG (RAD (ATOF (GET_TILE "leserichtung"))))
    (SETQ FIXPOS (GET_TILE "fixpos"))
    (SETQ OK WERT)
    (DONE_DIALOG WERT)
  )
  (DEFUN LESERICHTUNG_ZEIGER_CLEAR nil
    (START_IMAGE "zeiger")
    (FILL_IMAGE 0 0 W H -15)
    (SETQ WX 1)
    (REPEAT 8
      (VECTOR_IMAGE
	(NTH 0 MITTE)
	(NTH 1 MITTE)
	(FIX (NTH 0 (POLAR MITTE (* (/ PI 8) WX) W)))
	(FIX (NTH 1 (POLAR MITTE (* (/ PI 8) WX) W)))
	-18
      )
      (SETQ WX (+ WX 2))
    )
    (FILL_IMAGE X1 Y1 B1 H1 -15)
    (VECTOR_IMAGE X1 Y1 X1 Y2 -18)
    (VECTOR_IMAGE X1 Y2 X2 Y2 -18)
    (VECTOR_IMAGE X2 Y2 X2 Y1 -18)
    (VECTOR_IMAGE X2 Y1 X1 Y1 -18)
    (END_IMAGE)
  )
  (DEFUN LESERICHTUNG_ZEIGER nil
    (SETQ PX $X)
    (SETQ PY $Y)
    (SETQ LESERICHTUNG (ANGLE MITTE (LIST PX PY)))
    (IF	(NOT (AND (<= X1 PX X2) (<= Y1 PY Y2)))
      (COND ((AND (>= LESERICHTUNG (* PI 0.875))
		  (<= LESERICHTUNG (* PI 1.125))
	     )
	     (SETQ LESERICHTUNG PI)
	    )
	    ((AND (OR (>= LESERICHTUNG (* PI 1.875))
		      (<= LESERICHTUNG (* PI 0.125))
		  )
	     )
	     (SETQ LESERICHTUNG 0.0)
	    )
	    ((AND (>= LESERICHTUNG (* PI 1.375))
		  (<= LESERICHTUNG (* PI 1.625))
	     )
	     (SETQ LESERICHTUNG (* PI 1.5))
	    )
	    ((AND (>= LESERICHTUNG (* PI 0.375))
		  (<= LESERICHTUNG (* PI 0.625))
	     )
	     (SETQ LESERICHTUNG (* PI 0.5))
	    )
	    ((AND (> LESERICHTUNG (* PI 0.125))
		  (< LESERICHTUNG (* PI 0.375))
	     )
	     (SETQ LESERICHTUNG (* PI 0.25))
	    )
	    ((AND (> LESERICHTUNG (* PI 0.625))
		  (< LESERICHTUNG (* PI 0.875))
	     )
	     (SETQ LESERICHTUNG (* PI 0.75))
	    )
	    ((AND (> LESERICHTUNG (* PI 1.125))
		  (< LESERICHTUNG (* PI 1.375))
	     )
	     (SETQ LESERICHTUNG (* PI 1.25))
	    )
	    ((AND (> LESERICHTUNG (* PI 1.625))
		  (< LESERICHTUNG (* PI 1.875))
	     )
	     (SETQ LESERICHTUNG (* PI 1.75))
	    )
      )
    )
    (SET_TILE "leserichtung" (RTOS LESERICHTUNG))
    (SETQ P (POLAR MITTE LESERICHTUNG W))
    (LESERICHTUNG_ZEIGER_CLEAR)
    (START_IMAGE "zeiger")
    (VECTOR_IMAGE
      (FIX (NTH 0 P))
      (FIX (NTH 1 P))
      (FIX (/ W 2))
      (FIX (/ H 2))
      1
    )
    (END_IMAGE)
    (SET_TILE "leserichtung" (RTOS (- 360 (DEG LESERICHTUNG))))
  )
  (DEFUN LESERICHTUNG_WERT nil
    (SETQ LESERICHTUNG (* (/ (ATOF (GET_TILE "leserichtung")) -180) PI))
    (SETQ P (POLAR MITTE LESERICHTUNG W))
    (LESERICHTUNG_ZEIGER_CLEAR)
    (START_IMAGE "zeiger")
    (VECTOR_IMAGE
      (FIX (NTH 0 P))
      (FIX (NTH 1 P))
      (FIX (/ W 2))
      (FIX (/ H 2))
      1
    )
    (END_IMAGE)
  )
  (DEFUN LESERICHTUNG_VIEW nil
    (SETQ LESERICHTUNG
	   (- (* PI 2.0)
	      (+ (* PI 1.5) (- (* PI 2.0) (GETVAR "viewtwist")))
	   )
    )
    (WHILE (< LESERICHTUNG 0)
      (SETQ LESERICHTUNG (+ LESERICHTUNG (* PI 2.0)))
    )
    (WHILE (> LESERICHTUNG (* PI 2.0))
      (SETQ LESERICHTUNG (- LESERICHTUNG (* PI 2.0)))
    )
    (SETQ P (POLAR MITTE LESERICHTUNG W))
    (LESERICHTUNG_ZEIGER_CLEAR)
    (START_IMAGE "zeiger")
    (VECTOR_IMAGE
      (FIX (NTH 0 P))
      (FIX (NTH 1 P))
      (FIX (/ W 2))
      (FIX (/ H 2))
      1
    )
    (END_IMAGE)
    (SET_TILE "leserichtung" (RTOS (- 360 (DEG LESERICHTUNG))))
  )
  (SETQ LESERICHTUNG_ID (LOAD_DIALOG "k_func.dcl"))
  (IF (NOT (NEW_DIALOG "leserichtung" LESERICHTUNG_ID))
    (EXIT)
  )
  (SETQ W (DIMX_TILE "zeiger"))
  (SETQ H (DIMY_TILE "zeiger"))
  (SETQ MITTE (MAPCAR (QUOTE FIX) (LIST (/ W 2) (/ H 2))))
  (SETQ B1 (* (FIX (* W 0.3)) 2))
  (SETQ H1 (* (FIX (* H 0.3)) 2))
  (SETQ X1 (- (NTH 0 MITTE) (/ B1 2)))
  (SETQ Y1 (- (NTH 1 MITTE) (/ H1 2)))
  (SETQ X2 (+ (NTH 0 MITTE) (/ B1 2)))
  (SETQ Y2 (+ (NTH 1 MITTE) (/ H1 2)))
  (LESERICHTUNG_VIEW)
  (ACTION_TILE "zeiger" "(leserichtung_zeiger)")
  (ACTION_TILE "leserichtung" "(leserichtung_wert)")
  (ACTION_TILE "view" "(leserichtung_view)")
  (ACTION_TILE "accept" "(leserichtung_end '1)")
  (ACTION_TILE "cancel" "(leserichtung_end '0)")
  (SETQ AKTION (START_DIALOG))
  (UNLOAD_DIALOG LESERICHTUNG_ID)
  (IF (= OK 1)
    (LIST LESERICHTUNG FIXPOS)
    nil
  )
)
(DEFUN LESERICHTUNG_WINKEL (ENT_NAME LESERICHTUNG FIXPOS / ENT_DATA MINP MAXP W	P MEM_P)
  (SETQ ENT_DATA (ENTGET ENT_NAME))
  (COND	((= (CDR (ASSOC 0 ENT_DATA)) "LINE")
	 (vla-GetBoundingBox
	   (vlax-ename->vla-object ENT_NAME)
	   (QUOTE MINP)
	   (QUOTE MAXP)
	 )
	 (SETQ MINP (vlax-safearray->list MINP))
	 (SETQ MAXP (vlax-safearray->list MAXP))
	 (SETQ MEM_P (MAPCAR (QUOTE (LAMBDA (X1 X2) (/ (+ X1 X2) 2))) MINP MAXP))
	 (SETQ W (ANGLE (CDR (ASSOC 10 ENT_DATA)) (CDR (ASSOC 11 ENT_DATA))))
	 (SETQ W (WINKEL_LESBAR W LESERICHTUNG))
	 (IF (/= W
		 (SETQ W (ANGLE (CDR (ASSOC 10 ENT_DATA)) (CDR (ASSOC 11 ENT_DATA))))
	     )
	   (PROGN (SETQ P (CDR (ASSOC 10 ENT_DATA)))
		  (SETQ	ENT_DATA (SUBST	(CONS 10 (CDR (ASSOC 11 ENT_DATA)))
					(ASSOC 10 ENT_DATA)
					ENT_DATA
				 )
		  )
		  (SETQ ENT_DATA (SUBST (CONS 11 P) (ASSOC 11 ENT_DATA) ENT_DATA))
	   )
	 )
	 (ENTMOD ENT_DATA)
	 (vla-GetBoundingBox
	   (vlax-ename->vla-object ENT_NAME)
	   (QUOTE MINP)
	   (QUOTE MAXP)
	 )
	 (SETQ MINP (vlax-safearray->list MINP))
	 (SETQ MAXP (vlax-safearray->list MAXP))
	 (SETQ P (MAPCAR (QUOTE (LAMBDA (X1 X2) (/ (+ X1 X2) 2))) MINP MAXP))
	 (vla-Move (vlax-ename->vla-object ENT_NAME)
		   (vlax-3d-point P)
		   (vlax-3d-point MEM_P)
	 )
	)
	((= (CDR (ASSOC 0 ENT_DATA)) "TEXT")
	 (vla-GetBoundingBox
	   (vlax-ename->vla-object ENT_NAME)
	   (QUOTE MINP)
	   (QUOTE MAXP)
	 )
	 (SETQ MINP (vlax-safearray->list MINP))
	 (SETQ MAXP (vlax-safearray->list MAXP))
	 (SETQ MEM_P (MAPCAR (QUOTE (LAMBDA (X1 X2) (/ (+ X1 X2) 2))) MINP MAXP))
	 (SETQ W (CDR (ASSOC 50 ENT_DATA)))
	 (SETQ W (WINKEL_LESBAR W LESERICHTUNG))
	 (SETQ ENT_DATA (SUBST (CONS 50 W) (ASSOC 50 ENT_DATA) ENT_DATA))
	 (SETQ ENT_DATA (SUBST (CONS 71 0) (ASSOC 71 ENT_DATA) ENT_DATA))
	 (ENTMOD ENT_DATA)
	 (vla-GetBoundingBox
	   (vlax-ename->vla-object ENT_NAME)
	   (QUOTE MINP)
	   (QUOTE MAXP)
	 )
	 (SETQ MINP (vlax-safearray->list MINP))
	 (SETQ MAXP (vlax-safearray->list MAXP))
	 (SETQ P (MAPCAR (QUOTE (LAMBDA (X1 X2) (/ (+ X1 X2) 2))) MINP MAXP))
	 (vla-Move (vlax-ename->vla-object ENT_NAME)
		   (vlax-3d-point P)
		   (vlax-3d-point MEM_P)
	 )
	)
	((= (CDR (ASSOC 0 ENT_DATA)) "MTEXT")
	 (SETQ MEM_BREITE (ASSOC 41 ENT_DATA))
	 (SETQ ENT_DATA (SUBST (CONS 41 0.0) (ASSOC 41 ENT_DATA) ENT_DATA))
	 (ENTMOD ENT_DATA)
	 (vla-GetBoundingBox
	   (vlax-ename->vla-object ENT_NAME)
	   (QUOTE MINP)
	   (QUOTE MAXP)
	 )
	 (SETQ MINP (vlax-safearray->list MINP))
	 (SETQ MAXP (vlax-safearray->list MAXP))
	 (SETQ MEM_P (MAPCAR (QUOTE (LAMBDA (X1 X2) (/ (+ X1 X2) 2))) MINP MAXP))
	 (SETQ W (CDR (ASSOC 50 ENT_DATA)))
	 (SETQ W (WINKEL_LESBAR W LESERICHTUNG))
	 (SETQ ENT_DATA (SUBST (CONS 50 W) (ASSOC 50 ENT_DATA) ENT_DATA))
	 (ENTMOD ENT_DATA)
	 (vla-GetBoundingBox
	   (vlax-ename->vla-object ENT_NAME)
	   (QUOTE MINP)
	   (QUOTE MAXP)
	 )
	 (SETQ MINP (vlax-safearray->list MINP))
	 (SETQ MAXP (vlax-safearray->list MAXP))
	 (SETQ P (MAPCAR (QUOTE (LAMBDA (X1 X2) (/ (+ X1 X2) 2))) MINP MAXP))
	 (SETQ ENT_DATA (SUBST MEM_BREITE (ASSOC 41 ENT_DATA) ENT_DATA))
	 (ENTMOD ENT_DATA)
	 (vla-Move (vlax-ename->vla-object ENT_NAME)
		   (vlax-3d-point P)
		   (vlax-3d-point MEM_P)
	 )
	)
	((= (CDR (ASSOC 0 ENT_DATA)) "DIMENSION")
	 (SETQ W (- (* PI 1.75) (- LESERICHTUNG (* PI 1.75))))
	 (WHILE (>= W (* PI 2.0)) (SETQ W (- W (* PI 2.0))))
	 (IF (EQUAL W (* PI 2.0) 0.0001)
	   (SETQ W 0.0)
	 )
	 (SETQ MEM_DIMSTYLE (GETVAR "dimstyle"))
	 (COMMAND "_-DIMSTYLE" "_restore" (CDR (ASSOC 3 ENT_DATA)))
	 (COMMAND "_-DIMSTYLE" "_apply" ENT_NAME "")
	 (COMMAND "_-DIMSTYLE" "_restore" MEM_DIMSTYLE)
	 (SETQ TEXTPOSITION
		(K_VARIANT->VALUE
		  (vla-get-TextPosition
		    (SETQ OBJ_NAME (K_->OBJ_NAME ENT_NAME))
		  )
		)
	 )
	 (SETQ ENT_DATA_OLD ENT_DATA)
	 (SETQ ENT_DATA (SUBST (CONS 51 W) (ASSOC 51 ENT_DATA) ENT_DATA))
	 (ENTMOD ENT_DATA)
	 (IF (AND FIXPOS
		  (NOT
		    (EQUAL TEXTPOSITION
			   (K_VARIANT->VALUE (vla-get-TextPosition OBJ_NAME))
			   (* (vla-get-TextHeight OBJ_NAME) 0.001)
		    )
		  )
	     )
	   (PROGN (ENTMOD ENT_DATA_OLD)
		  (vla-put-DimTxtDirection
		    OBJ_NAME
		    (K_NOT (vla-get-DimTxtDirection OBJ_NAME))
		  )
	   )
	 )
	)
	((= (CDR (ASSOC 0 ENT_DATA)) "ATTRIB")
	 (IF (AND (= (BOOLE 1 1 (CDR (ASSOC 70 ENT_DATA))) 0)
		  (NOT (EQUAL (CDR (ASSOC 1 ENT_DATA)) ""))
	     )
	   (PROGN (vla-GetBoundingBox
		    (vlax-ename->vla-object ENT_NAME)
		    (QUOTE MINP)
		    (QUOTE MAXP)
		  )
		  (SETQ MINP (vlax-safearray->list MINP))
		  (SETQ MAXP (vlax-safearray->list MAXP))
		  (SETQ MEM_P (MAPCAR (QUOTE (LAMBDA (X1 X2) (/ (+ X1 X2) 2))) MINP MAXP))
		  (SETQ W (CDR (ASSOC 50 ENT_DATA)))
		  (SETQ W (WINKEL_LESBAR W LESERICHTUNG))
		  (SETQ ENT_DATA (SUBST (CONS 50 W) (ASSOC 50 ENT_DATA) ENT_DATA))
		  (ENTMOD ENT_DATA)
		  (ENTUPD ENT_NAME)
		  (vla-GetBoundingBox
		    (vlax-ename->vla-object ENT_NAME)
		    (QUOTE MINP)
		    (QUOTE MAXP)
		  )
		  (SETQ MINP (vlax-safearray->list MINP))
		  (SETQ MAXP (vlax-safearray->list MAXP))
		  (SETQ P (MAPCAR (QUOTE (LAMBDA (X1 X2) (/ (+ X1 X2) 2))) MINP MAXP))
		  (SETQ DIFF_P (MAPCAR (QUOTE -) P MEM_P))
		  (IF (ASSOC 11 ENT_DATA)
		    (PROGN (SETQ PX (CDR (ASSOC 11 ENT_DATA)))
			   (SETQ P (MAPCAR (QUOTE -) PX DIFF_P))
			   (SETQ ENT_DATA (SUBST (CONS 11 P) (ASSOC 11 ENT_DATA) ENT_DATA))
		    )
		    (PROGN (SETQ PX (CDR (ASSOC 10 ENT_DATA)))
			   (SETQ P (MAPCAR (QUOTE -) PX DIFF_P))
			   (SETQ ENT_DATA (SUBST (CONS 10 P) (ASSOC 10 ENT_DATA) ENT_DATA))
		    )
		  )
		  (ENTMOD ENT_DATA)
		  (ENTUPD ENT_NAME)
	   )
	 )
	)
	((= (CDR (ASSOC 0 ENT_DATA)) "INSERT")
	 (SETQ ATT_NAME ENT_NAME)
	 (SETQ ATT_DATA (ENTGET ATT_NAME))
	 (WHILE	(/= (CDR (ASSOC 0 ATT_DATA)) "SEQEND")
	   (IF (= (CDR (ASSOC 0 ATT_DATA)) "ATTRIB")
	     (PROGN
	       (IF (AND	(= (BOOLE 1 1 (CDR (ASSOC 70 ATT_DATA))) 0)
			(NOT (EQUAL (CDR (ASSOC 1 ATT_DATA)) ""))
		   )
		 (PROGN	(vla-GetBoundingBox
			  (vlax-ename->vla-object ATT_NAME)
			  (QUOTE MINP)
			  (QUOTE MAXP)
			)
			(SETQ MINP (vlax-safearray->list MINP))
			(SETQ MAXP (vlax-safearray->list MAXP))
			(SETQ MEM_P (MAPCAR (QUOTE (LAMBDA (X1 X2) (/ (+ X1 X2) 2))) MINP MAXP))
			(SETQ W (CDR (ASSOC 50 ATT_DATA)))
			(SETQ W (WINKEL_LESBAR W LESERICHTUNG))
			(SETQ ATT_DATA (SUBST (CONS 50 W) (ASSOC 50 ATT_DATA) ATT_DATA))
			(ENTMOD ATT_DATA)
			(ENTUPD ATT_NAME)
			(vla-GetBoundingBox
			  (vlax-ename->vla-object ATT_NAME)
			  (QUOTE MINP)
			  (QUOTE MAXP)
			)
			(SETQ MINP (vlax-safearray->list MINP))
			(SETQ MAXP (vlax-safearray->list MAXP))
			(SETQ P (MAPCAR (QUOTE (LAMBDA (X1 X2) (/ (+ X1 X2) 2))) MINP MAXP))
			(SETQ DIFF_P (MAPCAR (QUOTE -) P MEM_P))
			(IF (ASSOC 11 ATT_DATA)
			  (PROGN (SETQ PX (CDR (ASSOC 11 ATT_DATA)))
				 (SETQ P (MAPCAR (QUOTE -) PX DIFF_P))
				 (SETQ ATT_DATA (SUBST (CONS 11 P) (ASSOC 11 ATT_DATA) ATT_DATA))
			  )
			  (PROGN (SETQ PX (CDR (ASSOC 10 ATT_DATA)))
				 (SETQ P (MAPCAR (QUOTE -) PX DIFF_P))
				 (SETQ ATT_DATA (SUBST (CONS 10 P) (ASSOC 10 ATT_DATA) ATT_DATA))
			  )
			)
			(ENTMOD ATT_DATA)
			(ENTUPD ATT_NAME)
		 )
	       )
	     )
	   )
	   (SETQ ATT_NAME (ENTNEXT ATT_NAME))
	   (SETQ ATT_DATA (ENTGET ATT_NAME))
	 )
	)
  )
)
(DEFUN RAD (Z) (* (/ Z 180.0) PI))
(DEFUN WINKEL_LESBAR (W LESERICHTUNG)
  (IF (NULL LESERICHTUNG)
    (SETQ LESERICHTUNG (* PI 1.75))
  )
  (IF (MINUSP W)
    (SETQ W (+ (* PI 2) W))
  )
  (WHILE (>= W (* PI 2)) (SETQ W (- W (* PI 2))))
  (SETQ DUMMY (- LESERICHTUNG PI))
  (IF (MINUSP DUMMY)
    (SETQ DUMMY (+ (* PI 2) DUMMY))
  )
  (IF (OR (AND (> W (- LESERICHTUNG PI)) (< W LESERICHTUNG))
	  (> (- W LESERICHTUNG) PI)
      )
    (SETQ W (- W PI))
  )
  W
)

(defun c:k_text-vt (/ ENT_NAME FILTER FIXPOS LESERICHTUNG MEM_UCSFOLLOW N SATZ)
;;; Texte und Attribute lesbar drehen
  (vla-startundomark (k_ac-doc))
  (setvar "cmdecho" 0)
  (if (setq leserichtung (leserichtung_dialog))
    (progn
      (setq fixpos	 (k_is (cadr leserichtung))
	    leserichtung (- (car leserichtung) (getvar "viewtwist"))
      )
      (setq leserichtung (+ leserichtung (* pi 2.0) (/ pi 4)))
      (while (> leserichtung (* pi 2.0))
	(setq leserichtung (- leserichtung (* pi 2.0)))
      )
      (setq filter (list (cons -4 "<OR")
			 (cons 0 "LINE")
			 (cons 0 "TEXT")
			 (cons 0 "MTEXT")
			 (cons 0 "DIMENSION")
			 (cons -4 "<AND")
			 (cons 0 "INSERT")
			 (cons 66 1)
			 (cons -4 "AND>")
			 (cons -4 "OR>")
			 (cons 410
			       (cond
				 ((= (getvar "tilemode") 1)
				  "Model"
				 )
				 ((and (= (getvar "tilemode") 0) (= (getvar "cvport") 1))
				  (getvar "ctab")
				 )
				 (t "Model")
			       )
			 )
		   )
      )
      (if (if (setq satz (k_ssget "Objekte whlen oder ENTER fr alle" (list filter)))
	    t
	    (setq satz (ssget "x" filter))
	  )
	(progn
	  (command "_.ucs" "_delete" "k_text-vt")
	  (command "_.ucs" "_save" "k_text-vt")
	  (command "_.ucs" "_world")
	  (command-s "_view" "_d" "k_text-vt")
	  (command-s "_view" "_s" "k_text-vt")
	  (setq mem_ucsfollow (getvar "ucsfollow"))
	  (setvar "ucsfollow" 0)
	  (setq n (1- (sslength satz)))
	  (foreach ent_name (k_satz->entlist satz)
	    (princ (strcat "\r" (itoa n) " "))
	    (leserichtung_winkel ent_name leserichtung fixpos)
	    (setq n (1- n))
	  )
	  (command-s "_view" "_r" "k_text-vt")
	  (command-s "_view" "_d" "k_text-vt")
	  (command "_.ucs" "_restore" "k_text-vt")
	  (command "_.ucs" "_delete" "k_text-vt")
	  (setvar "ucsfollow" mem_ucsfollow)
	)
      )
    )
  )
  (vla-endundomark (k_ac-doc))
  (princ)
)
;;; - ------------------------------------------------------------------------------ - ;
(princ
  (strcat
    "\nK_text-vt:  Texte lesbar drehen"
    "\n===========  "
    "\n(C) Andreas Kraus 2022 (info@kraus-cad.de)"
    "\nBefehlszeilenaufruf : K_text-vt\n"
  )
)
;;; - ------------------------------------------------------------------------------ - ;
(princ)